/*
* Creation date : Tew Mar 06 13:32:57 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains implementation of 
* test functions for HMAC
* which worked with LibTomCrypt.
*
* \version CE2_TST_HMAC.c#1:csrc:1
* \author Masiuk Aliaksandr
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Include Files ***********************/

#include <memory.h>
#include "CE2_TST_Common.h"
#include "CE2_TST_HMAC.h"

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Global Data *************************/

/* test data definition */
TST_HMAC_TestDataStruct TST_HMAC_Acceptance_TestData[] =
{
        /****************************************/
        /*        HASH SHA1/MD5 vectors         */
        /****************************************/
    { 
        {"Acceptance test - HMAC/28ByteData "},
        /*HMAC TST_key*/
        {0x4a,0x65,0x66,0x65},/* "Jefe"*/
        /*HMAC TST_keySize */
        4*sizeof(DxUint8_t),
        /*TST_input_data*/
        {"what do ya want for nothing?"},
        /*0x77,0x68,0x61,0x74,
         0x20,
         0x64,0x6f,
         0x20,
         0x79,0x61,
         0x20,
         0x77,0x61,0x6e,0x74,
         0x20,
         0x66,0x6f,0x72, 
         0x20,
         0x6e,0x6f,0x74,0x68,0x69,0x6e,0x67,0x3f */
        /*TST_input_dataSize*/
        28*sizeof(DxUint8_t),
        /*TST_HashResultBuff*/
        {0},
        /*TST_SHA1_Expected_output_data*/
        {0xef,0xfc,0xdf,0x6a,0xe5,0xeb,0x2f,0xa2,0xd2,0x74,0x16,0xd5,0xf1,0x84,0xdf,0x9c,0x25,0x9a,0x7c,0x79}, 
        /*TST_SAH1_expected_dataSize*/
        CE2_HASH_SHA1_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_MD5_Expected_output_data*/
        {0x75,0x0c,0x78,0x3e,0x6a,0xb0,0xb5,0x03,0xea,0xa8,0x6e,0x31,0x0a,0x5d,0xb7,0x38}, 
        /*TST_MD5_Expeced_dataSize*/
        CE2_HASH_MD5_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),   
        /*TST_SHA224_Expected_output_data*/
        {0xa3,0x0e,0x01,0x09,0x8b,0xc6,0xdb,0xbf,0x45,0x69,0x0f,0x3a,0x7e,0x9e,0x6d,0x0f,
        0x8b,0xbe,0xa2,0xa3,0x9e,0x61,0x48,0x00,0x8f,0xd0,0x5e,0x44}, 
        /*TST_SAH224_expected_dataSize*/
        CE2_HASH_SHA224_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_SHA256_Expected_output_data*/
        {0x5b,0xdc,0xc1,0x46,0xbf,0x60,0x75,0x4e,0x6a,0x04,0x24,0x26,0x08,0x95,0x75,0xc7,
        0x5a,0x00,0x3f,0x08,0x9d,0x27,0x39,0x83,0x9d,0xec,0x58,0xb9,0x64,0xec,0x38,0x43}, 
        /*TST_SAH256_expected_dataSize*/
        CE2_HASH_SHA256_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_SHA384_Expected_output_data*/
        {0xaf,0x45,0xd2,0xe3,0x76,0x48,0x40,0x31,0x61,0x7f,0x78,0xd2,0xb5,0x8a,0x6b,0x1b,
        0x9c,0x7e,0xf4,0x64,0xf5,0xa0,0x1b,0x47,0xe4,0x2e,0xc3,0x73,0x63,0x22,0x44,0x5e,
        0x8e,0x22,0x40,0xca,0x5e,0x69,0xe2,0xc7,0x8b,0x32,0x39,0xec,0xfa,0xb2,0x16,0x49}, 
        /*TST_SAH384_expected_dataSize*/
        CE2_HASH_SHA384_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_SHA512_Expected_output_data*/
        {0x16,0x4b,0x7a,0x7b,0xfc,0xf8,0x19,0xe2,0xe3,0x95,0xfb,0xe7,0x3b,0x56,0xe0,0xa3,
        0x87,0xbd,0x64,0x22,0x2e,0x83,0x1f,0xd6,0x10,0x27,0x0c,0xd7,0xea,0x25,0x05,0x54,
        0x97,0x58,0xbf,0x75,0xc0,0x5a,0x99,0x4a,0x6d,0x03,0x4f,0x65,0xf8,0xf0,0xe6,0xfd,
        0xca,0xea,0xb1,0xa3,0x4d,0x4a,0x6b,0x4b,0x63,0x6e,0x07,0x0a,0x38,0xbc,0xe7,0x37}, 
        /*TST_SAH512_expected_dataSize*/
        CE2_HASH_SHA512_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        CE2_HASH_SHA1_mode
    },
    { 
        {"Acceptance test - HMAC/32byteKey/32ByteData "},
        /*TST_key*/
        {0xf6,0x4a,0xb2,0x3f,0x7a,0x95,0x92,0x9e,0x9e,0xa6,0x24,0xd9,0x5a,0x68,0x36,0xd5,
         0x12,0x83,0x65,0x0b,0x67,0xdc,0x90,0x2e,0x53,0x5a,0x8d,0x0d,0x75,0xf0,0x1a,0xbc},
        /*TST_keySize */
        32*sizeof(DxUint8_t),
        /*TST_input_data*/
        {0x57,0x22,0xd9,0xe2,0xed,0x48,0xf4,0x25,0xa8,0xce,0x7f,0x70,0x3d,0xe6,0xef,0x37,
         0xe7,0x32,0x71,0xc1,0x59,0xe4,0x7d,0x74,0xf8,0x24,0xae,0x53,0x47,0xb2,0xd1,0xc5},
        /*TST_input_dataSize*/
        32*sizeof(DxUint8_t),
        /*TST_HmacResultBuff*/
        {0},
        /*TST_SHA1_Expected_output_data*/
        {0x4f,0x52,0x68,0x65,0x5f,0xca,0x83,0x67,0x8e,0x8e,0x7a,0x8f,0x04,0x08,0x9d,0x13,
         0xf2,0x05,0x7b,0x16}, 
        /*TST_SHA1_Expected_output_dataSize*/
        CE2_HASH_SHA1_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),  
        /*TST_MD5_Expected_output_data*/
        {0x26,0x3b,0xf5,0x2e,0xb3,0x65,0xcf,0x3d,0xaa,0x7a,0x23,0x93,0xc7,0x73,0xc4,0x21}, 
        /*TST_MD5_Expeced_dataSize*/
        CE2_HASH_MD5_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),       
        /*TST_SHA224_Expected_output_data*/
        {0x39,0x43,0xe5,0xad,0xde,0xdf,0x6b,0xa2,0xd1,0xc3,0x9f,0xa8,0x49,0x6b,0x5e,0xa9,
        0xdd,0x3d,0x05,0xf5,0x5c,0xe0,0x54,0x11,0x2f,0x35,0x16,0x24}, 
        /*TST_SAH224_expected_dataSize*/
        CE2_HASH_SHA224_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_SHA256_Expected_output_data*/
        {0x11,0xaa,0x91,0x07,0xf5,0xe3,0x49,0x1f,0xb8,0x2c,0x69,0x5f,0x91,0xc1,0xf4,0xe7,
        0x7c,0x26,0xff,0xb9,0x2e,0x10,0x02,0xf8,0x3c,0x4a,0xcb,0xa0,0x27,0xc0,0x6c,0x46}, 
        /*TST_SAH256_expected_dataSize*/
        CE2_HASH_SHA256_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_SHA384_Expected_output_data*/
        {0xc8,0x26,0xee,0x38,0x96,0xb7,0x1a,0xc1,0x74,0xa4,0x7b,0x2a,0xc9,0x2e,0x6d,0x33,
        0xbe,0x65,0x1b,0x0f,0x0f,0xaf,0x64,0x38,0x7a,0x87,0x1c,0xdd,0x6b,0x5c,0x99,0x8a,
        0xf8,0x93,0x92,0x3d,0xc6,0x16,0x08,0x06,0x7c,0x9e,0xe7,0xe5,0x15,0xeb,0x64,0x1d}, 
        /*TST_SAH384_expected_dataSize*/
        CE2_HASH_SHA384_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_SHA512_Expected_output_data*/
        {0x64,0xb2,0x74,0xa2,0xe8,0xbd,0x8b,0x88,0xac,0x2e,0x05,0x0f,0x3b,0xa7,0xe3,0x9e,
        0x4c,0xea,0xcc,0x1e,0xbd,0x63,0x2a,0x96,0x7c,0x80,0xb8,0x76,0x0f,0xac,0xb3,0xf8,
        0xff,0x9e,0xef,0x1b,0x51,0x2e,0xf2,0x92,0xc5,0xb7,0x8e,0xb1,0x8b,0xd2,0x3f,0x0b,
        0x56,0xf4,0xbc,0x07,0xf9,0x7f,0x3c,0xef,0x6d,0x6f,0x79,0xc9,0x56,0x7a,0x1c,0xc0}, 
        /*TST_SAH512_expected_dataSize*/
        CE2_HASH_SHA512_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
        CE2_HASH_SHA1_mode           
    },      
    { 
        {"Acceptance test - HMAC/65byteKey/65ByteData "},
        /*TST_key*/
        {0x15,0xb2,0x9a,0xd8,0xae,0x2a,0xad,0x73,0xa7,0x26,0x43,0x50,0x70,0xe8,0xe9,0xda,
         0x9b,0x47,0x69,0xc3,0xe3,0xa4,0xee,0x99,0x6e,0x20,0x6a,0x9b,0x4f,0x0c,0x35,0xca,
         0x4f,0xa2,0xf7,0x43,0xed,0xf2,0xc7,0xcb,0xa3,0x1e,0x94,0xac,0x6b,0xca,0xc4,0xc0,
         0x82,0xcf,0x1c,0xcb,0x6c,0x2f,0xe0,0x0d,0x38,0x4e,0x3b,0x18,0x05,0x5f,0xe0,0xe0,
         0xc5},
        /*TST_keySize */
        65*sizeof(DxUint8_t),
        /*TST_input_data*/
        {0x99,0xfd,0x18,0xa3,0x5d,0x50,0x81,0x84,0xa6,0xf3,0x61,0xc6,0x7c,0xd9,0xb1,0x0b,
         0x4c,0xd1,0xd8,0xb2,0x46,0x57,0x2a,0x4d,0x03,0xb0,0xae,0x55,0x6b,0x36,0x24,0x1d,
         0xd6,0xf0,0x46,0x05,0x71,0x65,0x4f,0xf0,0xe4,0xb2,0xba,0xf8,0x31,0xdb,0x4c,0x60,
         0xdf,0x5f,0x54,0xc9,0x59,0x0f,0x32,0xa9,0x91,0x1f,0x16,0xfa,0xe8,0x7e,0x0a,0x2f,
         0x52},
        /*TST_input_dataSize*/
        65*sizeof(DxUint8_t),
        /*TST_HmacResultBuff*/
        {0},
        /*TST_SHA1_Expected_output_data*/
        {0x31,0x6a,0x2e,0x8c,0x84,0x29,0xf7,0x57,0xab,0x44,0x69,0x34,0x60,0x8d,0x41,0xf7,
         0x8d,0x2c,0xaa,0xe7}, 
        /*TST_SHA1_Expected_output_dataSize*/
        CE2_HASH_SHA1_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),
        /*TST_MD5_Expected_output_data*/
        {0xf6,0xee,0x43,0xb8,0xc6,0x20,0x01,0xd0,0x2e,0xb9,0xae,0x88,0x93,0xaa,0x8b,0x7d}, 
        /*TST_MD5_Expeced_dataSize*/
        CE2_HASH_MD5_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),   
        /*TST_SHA224_Expected_output_data*/
        {0x49,0x6d,0xa2,0x9c,0x2d,0xe2,0x62,0x93,0x68,0xb0,0xb4,0x25,0xf7,0x8d,0xdf,0x61,
        0x1f,0x9d,0x81,0x0f,0x45,0xda,0x65,0xb6,0xd5,0xc1,0xfd,0x51}, 
        /*TST_SAH224_expected_dataSize*/
        CE2_HASH_SHA224_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_SHA256_Expected_output_data*/
        {0x3c,0x4b,0x01,0xa3,0x09,0x80,0x10,0x17,0xd8,0x56,0x6a,0x2b,0xde,0x0a,0x0c,0x5d,
        0x31,0x49,0xd0,0xf1,0x09,0x46,0x5e,0x14,0x78,0x7a,0x9d,0xf7,0xf6,0x46,0x94,0x09}, 
        /*TST_SAH256_expected_dataSize*/
        CE2_HASH_SHA256_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_SHA384_Expected_output_data*/
        {0x51,0xcd,0x77,0x54,0xfd,0xcf,0x3c,0xf3,0xc7,0xad,0x35,0x09,0x4a,0x3a,0x50,0x04,
        0xf3,0xd9,0x7b,0x67,0x53,0x6e,0x73,0x58,0x7b,0xc9,0x1c,0xc5,0xcc,0x11,0x40,0x42,
        0x54,0xbf,0xa2,0x2a,0x79,0xb7,0x2e,0x34,0xe3,0x6e,0x8b,0x97,0xaf,0x00,0xc9,0xe7}, 
        /*TST_SAH384_expected_dataSize*/
        CE2_HASH_SHA384_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_SHA512_Expected_output_data*/
        {0x7f,0xac,0xed,0x1e,0x1c,0xea,0xc9,0x54,0xb9,0xc2,0xc7,0x92,0x60,0xab,0x7b,0x76,
        0xb5,0x5d,0xa1,0x5b,0xf1,0x75,0x47,0x70,0x32,0xa7,0x3b,0x74,0xde,0xfb,0xc3,0xd4,
        0xa7,0x41,0x15,0xb1,0xa0,0xd3,0x1a,0xc6,0xb4,0xd6,0x19,0x8d,0x4a,0x5d,0xf1,0x32,
        0x53,0xc5,0x52,0x10,0xe1,0xdc,0x4b,0x86,0xca,0xcc,0xd1,0x2f,0xe6,0x4c,0x67,0x6b}, 
        /*TST_SAH512_expected_dataSize*/
        CE2_HASH_SHA512_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
        CE2_HASH_SHA1_mode               
    },
    { 
        {"Acceptance test - HMAC/500byteKey/500ByteData "},
        /*TST_key*/
        {0xb8,0x34,0xbc,0xde,0x37,0x1e,0x06,0x23,0x3c,0xd4,0xd6,0x1d,0x52,0xc2,0xb7,0xb8,
         0x07,0x51,0x41,0xbd,0x4e,0xb7,0x9a,0x49,0x23,0x13,0x3d,0x7e,0x6d,0xb9,0xfa,0x78,
         0x28,0xca,0x3e,0x83,0xc3,0x09,0x95,0x8b,0xc7,0xe9,0x6d,0xd4,0xba,0xeb,0x1d,0xeb,
         0x43,0x26,0x26,0xdc,0x8f,0x27,0xb8,0xa5,0xf2,0xfc,0x78,0xeb,0xd2,0x8c,0x80,0xec,
         0xc1,0x2a,0xa7,0xb5,0xe9,0x69,0x03,0x94,0xad,0x31,0xad,0xd1,0x8d,0x12,0xc4,0x99,
         0x4a,0xd9,0xb5,0x3b,0x4b,0x61,0xb9,0x97,0x40,0xac,0x9f,0xd2,0x05,0x32,0xcb,0x4f,
         0xc9,0x79,0x7f,0xdb,0x6f,0xe6,0x59,0x28,0x34,0xd3,0x1d,0x7d,0x93,0xe2,0xb5,0xab,
         0x66,0x90,0x76,0x43,0x4d,0x0d,0xa5,0x06,0x53,0x4b,0x3a,0x9d,0xcf,0x54,0xe3,0x8b,
         0x89,0xe2,0x4c,0x5f,0x1e,0x29,0x9e,0x2e,0xa6,0xf8,0x46,0x40,0x93,0x00,0xf7,0x0a,
         0xdc,0x73,0xf2,0x5c,0x5c,0xd2,0x85,0xdc,0x75,0x00,0xd1,0xb3,0xf8,0x9a,0xd1,0x86,
         0x49,0x8b,0x98,0xa8,0xbe,0xda,0xda,0x8e,0x49,0xc7,0xae,0x83,0x57,0x17,0x92,0x9c,
         0xf7,0xac,0xb0,0xef,0x3f,0x58,0x60,0x00,0xeb,0xf3,0xed,0x7c,0x48,0xab,0x9c,0x2a,
         0x51,0x9c,0xea,0x1e,0x17,0xa1,0x16,0x30,0x66,0x69,0xdf,0xac,0xa5,0xcd,0x8f,0x4b,
         0xfe,0x60,0x38,0x62,0xbf,0x48,0x3e,0x5a,0x00,0x4d,0x15,0x60,0x87,0x30,0x4c,0x5d,
         0xe8,0x3e,0xcb,0x29,0xf0,0x24,0x59,0xfc,0x44,0x05,0x61,0x25,0x46,0xca,0xf5,0xfe,
         0x38,0xba,0x13,0x1f,0xa4,0x4a,0x27,0xd2,0xfb,0x36,0xd2,0xc7,0x7c,0xd0,0xea,0x09,
         0x57,0x98,0xc2,0x31,0x13,0x0e,0xab,0xda,0x2d,0xc4,0xba,0x54,0x02,0xb7,0xcc,0x9d,
         0xee,0xdf,0xc8,0x8c,0xb6,0x05,0x24,0x50,0x23,0xd5,0xab,0x19,0xf0,0x34,0x7d,0x15,
         0xe7,0xd4,0x57,0x9e,0x46,0x05,0x14,0xb2,0x67,0xce,0x74,0xa3,0xa0,0x3c,0x1d,0x0f,
         0x69,0xfa,0xdf,0x13,0xbc,0x22,0x3c,0xbc,0xc2,0x53,0x28,0xbe,0xab,0x04,0x0d,0x69,
         0xdd,0x17,0x12,0xd8,0x52,0xb1,0x9d,0x6c,0x3b,0x4a,0x16,0x79,0xea,0x00,0xef,0x3e,
         0xee,0x31,0xe1,0x1b,0x80,0x48,0x78,0xfe,0x1e,0xd7,0xd1,0x1f,0x75,0xe7,0xa3,0xed,
         0x84,0x8c,0x7c,0x47,0xff,0xbc,0x4d,0xf0,0xf1,0x60,0x29,0x3d,0xa6,0xac,0x4a,0x11,
         0xc8,0xac,0x55,0x0b,0xc8,0x20,0xde,0xfe,0x7f,0x8a,0x2f,0xa2,0x16,0x85,0x45,0x89,
         0x23,0x58,0x1c,0x54,0x14,0xcb,0x2d,0x26,0xd1,0x3a,0x34,0x59,0x9d,0xe7,0x36,0x70,
         0x3d,0x94,0xc3,0x4d,0x5d,0x52,0x79,0xa5,0x2f,0x94,0xc9,0xb0,0x55,0x87,0xfe,0x25,
         0x01,0xa6,0x7a,0x65,0x5b,0x89,0x43,0xf6,0x23,0xfd,0xbf,0x34,0x97,0x5a,0xbc,0x43,
         0x97,0x11,0xb3,0x48,0x07,0x85,0x4e,0xd9,0x75,0x1c,0x27,0xb2,0xfb,0x95,0xd3,0xa9,
         0x67,0x9c,0x1f,0xe4,0x9a,0x9b,0x99,0x49,0x2e,0xd4,0x53,0x36,0x5c,0xad,0xe3,0x72,
         0x1c,0x4a,0xae,0x64,0x8d,0x61,0x67,0x83,0x98,0x4a,0xd2,0x0e,0xd0,0x56,0xce,0xfd,
         0x9d,0x62,0x92,0x37,0x9a,0xac,0x37,0x05,0x3b,0xe5,0x77,0xc7,0xb3,0x87,0xb4,0xe6,
         0x15,0x68,0x3b,0x09},
        /*TST_keySize */
        500*sizeof(DxUint8_t),
        /*TST_input_data*/
        {0xa2,0x86,0x21,0xea,0x6d,0x3c,0xfb,0xaa,0x86,0x2a,0xc9,0xb6,0x3e,0xa9,0x90,0xd0,
         0xe3,0x24,0x22,0x54,0xef,0x7a,0xef,0xbd,0x80,0xa4,0x1e,0x6a,0x08,0x98,0xdd,0xa3,
         0x46,0x6d,0xf5,0xd7,0x75,0xbf,0xa1,0x27,0xc3,0x55,0xa0,0x29,0x04,0x01,0x89,0xe5,
         0xa8,0xc8,0x5f,0x24,0xea,0x43,0x65,0xeb,0x4b,0x45,0x33,0x42,0x3f,0xbf,0x0a,0x39,
         0x26,0xe0,0x65,0x2d,0x7d,0x80,0xd0,0x48,0x56,0xbe,0xfd,0x47,0x05,0xe8,0x15,0x80,
         0x1d,0x9c,0x4c,0x23,0x9b,0x2d,0xb8,0xc0,0x60,0x48,0x63,0x09,0xe5,0xd8,0x9f,0xda,
         0x2a,0x26,0x99,0x76,0xef,0x45,0x31,0x14,0x27,0xad,0x09,0x9a,0xaa,0x26,0xdc,0xa8,
         0x2a,0xe8,0x12,0xd8,0x68,0x00,0x91,0x44,0xa7,0xf5,0xd5,0x49,0x61,0xac,0x43,0x8b,
         0x3a,0x89,0xba,0x39,0x32,0xd7,0x6c,0x93,0x1e,0x6a,0xec,0xa9,0x59,0x82,0x87,0x65,
         0xb7,0xf3,0xd8,0xcb,0xba,0x83,0x97,0x80,0x09,0x94,0xb2,0x89,0x1d,0x03,0x9f,0x56,
         0x3e,0x4f,0xf0,0xff,0xae,0xfe,0x28,0xcd,0x24,0x3c,0xcd,0xfc,0x7b,0xc6,0xbe,0xbf,
         0xac,0x06,0xc7,0x85,0xfa,0x7f,0x73,0x7b,0x6c,0x6c,0x21,0x52,0x80,0xa4,0x5a,0x42,
         0x1e,0xc1,0x62,0x4f,0xcb,0x81,0x0d,0xcb,0x1f,0x6d,0xd4,0x1c,0x79,0xb8,0x28,0xbf,
         0xf1,0x69,0x07,0x8d,0x8e,0xbd,0xcc,0x3d,0xba,0xc6,0x4b,0x2b,0xf2,0x59,0x1d,0x57,
         0xc2,0x27,0x39,0xb1,0xf1,0x2a,0xc4,0x94,0xf9,0x43,0x2b,0x90,0xb9,0x21,0x6e,0x6c,
         0x6e,0x64,0xbf,0x6b,0xe0,0x02,0x4b,0xcf,0xd9,0xea,0x58,0x9c,0xdb,0xe8,0x90,0x9e,
         0x12,0xc9,0x9c,0xad,0x88,0xbf,0xf5,0x30,0x98,0x07,0xf7,0xe0,0xa5,0xc8,0x38,0xcf,
         0x0c,0x3f,0x17,0xa8,0x56,0x19,0x98,0x38,0xb3,0x20,0x6f,0x2d,0xa4,0x1a,0x5a,0x1e,
         0xf7,0xee,0xb4,0xcc,0xf8,0x09,0x48,0xa8,0xe6,0x00,0x63,0x95,0xa4,0x77,0x2d,0xee,
         0xb1,0x41,0x38,0xcb,0x5a,0xc9,0x5a,0x80,0x2e,0xb0,0xb8,0x67,0xb3,0xb7,0x24,0xe0,
         0x57,0xe0,0xa9,0x95,0xa9,0xd0,0x63,0x03,0xc9,0x78,0x94,0x36,0x1d,0xf4,0xf5,0xd3,
         0x46,0xb3,0x4a,0x5c,0x53,0xd9,0x39,0xb0,0x34,0xe1,0x5c,0xd1,0x71,0x87,0x95,0xea,
         0x1c,0xe5,0xa2,0x91,0x04,0xdc,0xf1,0x49,0x2b,0xb5,0xb5,0x4b,0x7a,0x08,0x39,0x86,
         0xb4,0xdd,0x74,0xe4,0xa9,0x12,0xdf,0xcf,0xac,0xfd,0x83,0xf4,0x46,0x51,0x56,0x46,
         0x2c,0x46,0xc7,0x46,0x6f,0xf4,0x98,0x82,0xf3,0x00,0xec,0x5c,0x22,0x7b,0xa1,0x0d,
         0xe1,0x07,0xdf,0xea,0xc3,0x3c,0xf1,0xe5,0x7d,0x4a,0x54,0x56,0x9b,0xdf,0x0e,0xfc,
         0x71,0x4b,0x41,0x3e,0x53,0xe2,0x00,0xb7,0x09,0xa1,0x61,0xf2,0x7d,0x15,0xd4,0x72,
         0xb7,0x79,0xb3,0xf6,0x0b,0x1f,0x1a,0xfb,0x91,0x11,0xf8,0x81,0xd6,0xf7,0x66,0x12,
         0xd1,0x3b,0x38,0x01,0x19,0x6c,0xd2,0xf0,0x55,0xe0,0x3e,0x94,0xf3,0x9e,0x7b,0xbd,
         0x1d,0x7a,0x17,0x90,0xe8,0x82,0x00,0x17,0xcf,0x99,0x97,0xfd,0x61,0x62,0x06,0x92,
         0x36,0x60,0xd3,0x15,0x27,0x5b,0xb6,0x33,0xbe,0x05,0xa8,0xcb,0xec,0xdd,0x3d,0xf4,
         0xfa,0x54,0x33,0x41},
        /*TST_input_dataSize*/
        500*sizeof(DxUint8_t),
        /*TST_HmacResultBuff*/
        {0},
        /*TST_SHA1_Expected_output_data*/
        {0xb8,0x6c,0x2f,0xc2,0xa9,0x99,0x3a,0x80,0x06,0xcd,0x73,0xf6,0x18,0xba,0x86,0xa1,
         0xc0,0xc1,0xf2,0xea}, 
        /*TST_SHA1_Expected_output_dataSize*/
        CE2_HASH_SHA1_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),
        /*TST_MD5_Expected_output_data*/
        {0x66,0xd2,0x67,0x96,0x8d,0x03,0x46,0xfc,0x85,0xa4,0xa4,0x30,0xda,0xbd,0xbe,0xb5}, 
        /*TST_MD5_Expeced_dataSize*/
        CE2_HASH_MD5_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
        /*TST_SHA224_Expected_output_data*/
        {0x25,0xd5,0x9d,0x26,0x86,0x1e,0xbf,0xbe,0xa7,0xcf,0x42,0x7e,0xb3,0x8b,0xca,0x56,
        0xb0,0x97,0x04,0xd6,0x34,0x6f,0x73,0x72,0xc0,0xf7,0xba,0xe3}, 
        /*TST_SAH224_expected_dataSize*/
        CE2_HASH_SHA224_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_SHA256_Expected_output_data*/
        {0xd1,0xad,0x7f,0x4a,0x89,0x27,0x16,0x3b,0xba,0xc4,0x47,0xef,0xfc,0xd1,0xf8,0xe3,
        0xd9,0x60,0x50,0x98,0xf6,0x82,0xf9,0x0c,0xaf,0x19,0x07,0xa1,0xcd,0x88,0xae,0x19}, 
        /*TST_SAH256_expected_dataSize*/
        CE2_HASH_SHA256_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_SHA384_Expected_output_data*/
        {0x93,0x05,0x91,0xfd,0xdc,0x9e,0x2a,0x76,0x26,0x3f,0x29,0xdf,0x92,0xce,0x3f,0xed,
        0xec,0xe8,0x02,0xcb,0x79,0x2a,0xf7,0x53,0x5b,0x6b,0x19,0x29,0xf1,0xe4,0xd0,0xcf,
        0x80,0x0b,0x97,0xf9,0x9c,0xbd,0x68,0xfe,0xc4,0x30,0x02,0xd9,0xa7,0x74,0x90,0x38}, 
        /*TST_SAH384_expected_dataSize*/
        CE2_HASH_SHA384_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_SHA512_Expected_output_data*/
        {0x6b,0x05,0xac,0x04,0x8f,0xc4,0xec,0x5a,0xfe,0x78,0x67,0x7d,0x2f,0x81,0xd2,0xe2,
        0x14,0x9e,0xc8,0x8a,0x49,0x2a,0x55,0x84,0x63,0x34,0x8e,0x19,0x10,0xaf,0x59,0x25,
        0x86,0x50,0x67,0xa9,0xe9,0x1e,0x18,0xfb,0x74,0x2a,0x96,0x04,0x64,0xe0,0x5a,0x88,
        0x38,0x99,0x73,0x49,0x46,0x79,0xd3,0xab,0x8c,0xd9,0x99,0x2a,0x0f,0x10,0x41,0x67}, 
        /*TST_SAH512_expected_dataSize*/
        CE2_HASH_SHA512_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
        CE2_HASH_SHA1_mode               
    },
    { 
        {"Acceptance test - HMAC/32byteKey/1536ByteData "},
        /*TST_key*/
        {0x88,0x50,0xb0,0x58,0x33,0x99,0x35,0xe8,0x6f,0x6a,0x7a,0x36,0x69,0x06,0x3f,0x55,
        0x01,0xa4,0x77,0xbd,0xd9,0x2a,0xfa,0x36,0xac,0x38,0x7a,0xf8,0xe2,0x68,0xb8,0x10},
        /*TST_keySize */
        32*sizeof(DxUint8_t),
        /*TST_input_data*/
        {0xb0,0x37,0x14,0x55,0x76,0x15,0x22,0x6d,0xa7,0x58,0x15,0xa5,0x0f,0x2c,0xb4,0xb4,
        0x5d,0x15,0xc6,0x58,0x26,0xe0,0x32,0xea,0x2c,0xda,0x65,0x35,0xdf,0x3f,0xf4,0x88,
        0x24,0xf5,0x82,0x0a,0x56,0x7a,0xe5,0x4e,0x8a,0x1c,0x84,0x27,0x18,0x68,0x03,0xbe,
        0x57,0xe4,0x23,0xe1,0xa7,0x01,0xe3,0x9e,0xb5,0x4b,0xec,0x11,0xfa,0xe3,0x2b,0x7a,
        0x85,0x2f,0xc0,0x92,0xfb,0xd0,0x17,0x20,0xdc,0xd4,0x54,0xc7,0x07,0x2d,0xf5,0x22,
        0x81,0x62,0xb2,0x13,0x72,0x85,0xa8,0x57,0x70,0x65,0xb7,0x5e,0x00,0x04,0x29,0x5a,
        0x5a,0x4c,0x94,0x97,0x6d,0xfd,0x01,0x0a,0x23,0xea,0x4d,0x2c,0xe6,0x65,0xd0,0x09,
        0x63,0xf8,0x3d,0x93,0x8e,0x56,0xc9,0x3d,0xe6,0x90,0x90,0xc5,0xfa,0x8c,0x34,0x51,
        0x2c,0xb4,0xc7,0xbe,0xb5,0xeb,0xeb,0x35,0xe9,0xc5,0x37,0xff,0xbc,0xf7,0xdd,0x9a,
        0x86,0x0c,0x8a,0x0c,0x03,0x5a,0x8e,0x77,0x9e,0x35,0x3d,0xee,0xef,0x62,0x95,0x87,
        0x82,0xce,0x21,0xb1,0xda,0x80,0x1c,0xc8,0xb5,0xcd,0xda,0xe7,0x92,0xcb,0x64,0xfe,
        0x71,0x08,0x63,0x24,0xda,0x7b,0x3f,0x2e,0x20,0xba,0x87,0x80,0xe7,0x6e,0x94,0x23,
        0xe4,0x04,0x69,0x18,0xe4,0xa6,0xde,0xec,0x10,0x6a,0xfe,0x8d,0x6f,0xc9,0xad,0x5c,
        0xac,0x52,0x8e,0x83,0x1a,0x9f,0x23,0x89,0xf5,0x89,0x36,0x24,0xeb,0x98,0x78,0x4e,
        0xda,0xbd,0x69,0x9a,0xdc,0x44,0x77,0xc9,0x81,0x04,0x6a,0x98,0x5b,0xd9,0xff,0xdd,
        0xc0,0x54,0xd3,0xd2,0xcb,0xb0,0x83,0xb1,0xa4,0x08,0x12,0x81,0x01,0xc8,0x8b,0x2f,
        0xed,0x62,0xe7,0xe0,0xc9,0x42,0x30,0x86,0x90,0x03,0xe7,0xb1,0x5f,0xe3,0xa4,0xa9,
        0x34,0x74,0xfc,0xb9,0xf5,0x95,0xa7,0xcd,0xb5,0xa1,0xe2,0x40,0x34,0xe6,0x13,0xef,
        0xa4,0x59,0xac,0x92,0xb3,0x87,0x51,0x4c,0xc5,0xcf,0x3d,0x80,0x81,0xcf,0xe2,0xe7,
        0x90,0x1c,0xcf,0xdf,0xa1,0x36,0xd7,0x06,0xb1,0xbb,0x70,0x08,0x89,0xda,0x59,0xb5,
        0x88,0x0b,0x80,0x57,0xa2,0xfd,0x22,0x42,0xa9,0xd0,0x34,0xac,0xcb,0x85,0x02,0xbf,
        0x5d,0xb3,0x16,0xed,0xd7,0x7b,0x5b,0x84,0x1f,0xbd,0x82,0x82,0x0a,0x8c,0xa5,0xaa,
        0x20,0xe0,0x2a,0xd7,0x9f,0x8b,0xeb,0x91,0xc3,0x6f,0x93,0xde,0x45,0xed,0x4b,0x5a,
        0x21,0xa1,0x97,0x8a,0x9d,0x4c,0x7a,0x6e,0x87,0x11,0xe1,0x55,0xbe,0xe5,0x3f,0xf5,
        0xf4,0x41,0x74,0xbb,0xb1,0x19,0xf3,0x60,0x9b,0x12,0x24,0xbd,0xf6,0xf0,0x07,0xe0,
        0x67,0x4d,0x1b,0x5f,0xfd,0x91,0x7e,0xec,0x71,0x1e,0x55,0x2a,0xad,0xcb,0x6e,0xc0,
        0x8c,0x94,0x24,0xab,0xe1,0x90,0x83,0xd8,0xba,0x23,0xad,0xf2,0xe6,0x74,0x7c,0x79,
        0xb4,0x21,0x69,0x14,0xfe,0x32,0xad,0x28,0x66,0x4c,0xa6,0xa9,0xe0,0x27,0x7b,0x30,
        0x71,0x42,0x03,0x4e,0x36,0xd6,0xe3,0x21,0xa7,0x08,0xf7,0x24,0x1d,0x62,0xf4,0x4b,
        0x92,0x84,0x4b,0x50,0xa8,0x17,0x50,0x47,0xed,0x03,0x9b,0x79,0x5e,0xe2,0xae,0x6f,
        0x2a,0xb4,0xd9,0x4d,0xb8,0xd4,0x5b,0x62,0xea,0x2b,0xca,0xfc,0xa4,0xa3,0xb5,0x81,
        0x88,0xde,0x87,0xbb,0x04,0x29,0xae,0x74,0x8f,0xab,0xfd,0x43,0x2f,0xe2,0x4f,0xa5,
        0x3f,0x51,0x6e,0x4f,0x6f,0x72,0x33,0xc3,0x0c,0xf2,0xee,0x22,0x82,0x1d,0x07,0x41,
        0x1f,0x98,0xe6,0xfe,0x19,0x4e,0x11,0xd5,0xd3,0xac,0x94,0xae,0x5c,0x11,0xa6,0xf9,
        0x38,0x80,0x89,0xfd,0x64,0x99,0xb2,0x6d,0x94,0xc7,0x2a,0x3d,0xbf,0xba,0x34,0xb3,
        0xdd,0x18,0x30,0xc1,0xf0,0x6f,0xbf,0x92,0x41,0x6f,0x28,0x63,0xec,0x56,0xfb,0x94,
        0x9e,0xab,0xf4,0xff,0x9e,0x2f,0x21,0x88,0x0a,0x11,0x47,0xf5,0x64,0x61,0x83,0x01,
        0x4d,0xc7,0x2d,0xab,0x8f,0x75,0x01,0xd4,0x61,0x5a,0x81,0x09,0xe7,0x98,0x95,0x9e,
        0xf9,0x39,0x75,0xfc,0x25,0x1d,0xc8,0x3b,0xf7,0x37,0x0e,0xf4,0x77,0xfa,0x3b,0x50,
        0xf4,0x0d,0xa4,0x65,0x00,0x46,0x1f,0xc3,0xbc,0xd6,0x66,0x49,0x56,0xc1,0xbd,0x3e,
        0xcf,0x92,0xd5,0x9d,0x02,0x4c,0xef,0xaf,0xe2,0xa3,0x44,0xdf,0x03,0x6c,0xa5,0xcb,
        0x5c,0x53,0x5f,0x97,0x4b,0xcc,0x61,0x86,0xd9,0x4c,0xa1,0xcb,0x40,0xb8,0xbb,0x9c,
        0xaa,0x1e,0xdb,0x89,0x3c,0xa3,0xde,0x0c,0x53,0xbc,0xb4,0x61,0x0d,0xa1,0x09,0x97,
        0x0c,0xff,0x24,0xe8,0x76,0xed,0x0f,0x46,0x40,0x22,0xf8,0x36,0xad,0x65,0xd7,0xe1,
        0x11,0x44,0x51,0x68,0xdb,0x09,0xdc,0x79,0xd2,0xea,0x25,0x20,0x9f,0x80,0xaf,0xdf,
        0x8c,0x7b,0xbc,0x00,0x8b,0x93,0x70,0x2a,0x7a,0xc2,0x34,0x33,0xa5,0xb0,0x59,0x35,
        0x8d,0x6f,0xfd,0xe4,0xe8,0x68,0x33,0x1e,0xe8,0x95,0x5e,0xc4,0xc0,0xf1,0xde,0xc9,
        0x65,0x2d,0xef,0x88,0x91,0xa5,0xcd,0x5b,0x0e,0x92,0x1d,0x69,0x31,0x81,0x88,0xbf,
        0xa5,0x04,0xa9,0xa3,0x69,0xa7,0x29,0x24,0x1c,0x25,0x28,0xf6,0x79,0xdc,0xdf,0x7d,
        0x1e,0x7f,0x84,0x28,0x91,0x0b,0x6e,0x00,0x84,0xfc,0x7a,0x81,0x58,0xc0,0xad,0xa8,
        0xe1,0x6c,0x1b,0x4d,0x69,0xae,0x07,0xb3,0xf7,0x02,0x4b,0x5e,0xd1,0x29,0xfb,0x24,
        0x3f,0xd8,0x45,0x87,0x92,0xad,0x9b,0x42,0x65,0x66,0x15,0x22,0x23,0x55,0x10,0x17,
        0xc9,0x0f,0x1c,0x8b,0xed,0x65,0x15,0xf2,0x00,0x95,0x8f,0xa3,0xd0,0xc1,0x77,0xe6,
        0x50,0x9f,0xf8,0x4e,0x9c,0x73,0x9c,0x49,0x38,0x3a,0xb4,0xf5,0x98,0x28,0xf9,0x35,
        0xe6,0x55,0x73,0x05,0xff,0xb4,0x9a,0x0a,0xbf,0x44,0xbc,0x6d,0x7e,0x8a,0x9e,0xea,
        0xda,0x3e,0x66,0x24,0xb7,0x45,0xb8,0x3c,0x85,0xdf,0x20,0xa1,0xc2,0x22,0xb0,0x2a,
        0xbf,0xa7,0xea,0x62,0xa6,0x83,0xe0,0x23,0xbc,0x78,0x99,0x66,0xe4,0x6d,0xb7,0x59,
        0x65,0x1c,0x57,0xb2,0xec,0x0b,0x39,0x43,0xd5,0xbd,0x21,0xcf,0xa6,0x29,0x7c,0x1d,
        0xdc,0x6b,0x47,0x4a,0xeb,0xba,0x2d,0x63,0x80,0x9a,0xef,0x34,0x09,0x52,0x09,0x5a,
        0x77,0xa1,0x93,0xa0,0x42,0xad,0x65,0x88,0xae,0x3c,0x7e,0x27,0x4e,0x26,0xa7,0x36,
        0xc6,0x0b,0x53,0x67,0xd4,0x41,0xca,0xf5,0x92,0x10,0x86,0x7f,0xf5,0x22,0xdd,0x16,
        0x9a,0x35,0xe1,0x95,0xc2,0x13,0x85,0x30,0x9b,0xc4,0x01,0x50,0xc1,0x02,0x77,0x9f,
        0x04,0xed,0xd6,0x5e,0x6c,0x00,0xff,0xff,0x7a,0x44,0x26,0xf0,0xb1,0xc3,0x7b,0xb5,
        0x55,0x40,0x0a,0x39,0x73,0x25,0xe0,0x66,0x21,0xbd,0x70,0xf3,0x07,0xa3,0x35,0x7d,
        0x1e,0x7b,0x98,0xda,0xb8,0xdf,0x13,0xaa,0xc1,0x9c,0x97,0x2e,0x44,0x1f,0x2b,0x5e,
        0x30,0x2a,0xd7,0x35,0x5d,0xcc,0xc0,0x50,0xca,0x8f,0x94,0xb7,0x29,0xf3,0x28,0xfb,
        0x9d,0x1b,0x60,0x81,0xc2,0xc7,0x50,0x1d,0xee,0x82,0xa0,0xe2,0xb6,0x1d,0x35,0x39,
        0xb4,0x5b,0x0d,0x31,0x88,0xee,0x6b,0x16,0x1d,0xa2,0x35,0x45,0x2e,0xd9,0x9a,0x3e,
        0x08,0x37,0xf7,0xfb,0x91,0x9e,0xfc,0x81,0x89,0x5d,0x0b,0xb4,0x10,0xa4,0xe0,0x6f,
        0x68,0x3c,0x77,0xd4,0xfd,0x74,0x2a,0xe1,0xa2,0x5f,0x1b,0x44,0x1e,0x3c,0xd1,0x71,
        0xe7,0x36,0x26,0xf1,0x2d,0x4e,0x60,0xfd,0x1a,0x95,0x9e,0x4b,0x59,0x9e,0x76,0x28,
        0xd5,0x33,0xdc,0xc7,0xc3,0x47,0x45,0xd9,0xe2,0x2c,0x0d,0x5d,0x01,0x06,0x16,0xba,
        0xc3,0x80,0xb3,0x0b,0x9f,0xbd,0xc4,0xba,0x2a,0x92,0x22,0x50,0x99,0xf2,0x3d,0x8b,
        0x81,0xa9,0x03,0xb2,0xe2,0x4d,0x04,0x25,0x64,0x72,0xd4,0x38,0xe0,0x1e,0xb1,0x41,
        0x22,0x7d,0x66,0xf0,0xee,0xd5,0x6f,0xdf,0x40,0xbb,0x5e,0x6a,0xd8,0x88,0x7e,0xc1,
        0xf6,0x07,0xb5,0x3b,0x63,0x70,0xaf,0xee,0xb0,0x9a,0x38,0x7c,0xc2,0x6c,0xea,0x2f,
        0x8f,0x95,0x09,0x49,0x22,0x7c,0xab,0x95,0xe5,0x7a,0x1c,0x42,0x1f,0x48,0x80,0xf1,
        0xbc,0xb3,0xba,0x0d,0x4d,0x97,0x8d,0x5b,0x4f,0x0a,0x01,0xd2,0xb0,0xd8,0x09,0xac,
        0x8f,0x30,0x62,0xbd,0x44,0x9c,0xbe,0x04,0xa0,0x36,0x22,0x80,0x75,0x1a,0x8d,0x44,
        0x59,0x17,0xda,0xce,0xa8,0xaa,0xe7,0x95,0xc8,0x2c,0xf7,0xe1,0xb1,0x4a,0x55,0xdf,
        0xac,0xb6,0x3b,0xf5,0x5a,0x1c,0xf1,0x53,0xf9,0x58,0x39,0xcb,0xe3,0xe6,0xeb,0xe2,
        0x57,0x99,0xdd,0x27,0x7c,0x90,0x05,0xc3,0xa3,0x67,0xe2,0x52,0xcd,0xaa,0x17,0xf1,
        0x6d,0x8f,0x5a,0x98,0x6f,0xe4,0x8c,0xab,0x78,0x46,0x29,0xcb,0x70,0x94,0xe3,0xf2,
        0x3e,0xa3,0x8a,0xbf,0xd2,0x33,0x2f,0x0e,0x69,0x22,0x89,0xcc,0x0c,0xe0,0x98,0x0a,
        0x5a,0x23,0x87,0x4f,0x88,0xdc,0xd7,0x33,0xa6,0x69,0xba,0x29,0x24,0x0c,0xbd,0x9d,
        0x94,0x9c,0xaa,0x3f,0xb1,0x7a,0xad,0x9e,0xa1,0xc7,0xb5,0xf8,0x77,0xd4,0x1d,0x50,
        0xfc,0xda,0x8c,0xc2,0xaf,0xec,0x1a,0x14,0x0a,0x29,0xb4,0x8d,0x07,0x36,0xc1,0x0a,
        0xe3,0xec,0x05,0x4e,0x22,0x4d,0xc6,0x9a,0xd3,0xbd,0x2e,0x7d,0x15,0x6f,0xf1,0xee,
        0xda,0x1d,0x30,0x98,0xeb,0xfc,0x9c,0x75,0x2d,0xef,0xde,0x9e,0x22,0xfa,0x37,0x62,
        0xb2,0xfa,0x63,0x95,0x2c,0x94,0xc4,0x2a,0x88,0x6c,0xbc,0x05,0xef,0x97,0x5b,0x0a,
        0x7d,0x52,0x3a,0x7a,0x45,0xf4,0xa6,0x7f,0x95,0x21,0x01,0x05,0x7c,0x41,0x66,0xcc,
        0x8a,0x30,0x8c,0xbb,0xd7,0x37,0xed,0x78,0x46,0x3c,0x27,0x35,0x0b,0x35,0xa2,0xcd,
        0x6b,0xe3,0x73,0x0f,0xc3,0xbc,0x80,0x59,0xcc,0x29,0xe5,0x6a,0x1d,0xf1,0x97,0x71,
        0xf2,0xf5,0x47,0x69,0x2b,0x1f,0x8a,0xa9,0x98,0x95,0x36,0xb7,0x73,0x32,0x0f,0x5e,
        0x2e,0x36,0xa3,0x00,0x70,0x3c,0x72,0x2d,0x5a,0x6d,0x52,0x73,0x0e,0xf4,0x12,0x78,
        0x72,0xb1,0x5e,0x47,0x31,0x32,0xe2,0xe8,0x03,0xdf,0xb3,0x33,0x2f,0x74,0xea,0xe5},
        /*TST_input_dataSize*/
        1536*sizeof(DxUint8_t),
        /*TST_HmacResultBuff*/
        {0},
        /*TST_SHA1_Expected_output_data*/
        {0xfa,0x57,0x3b,0x54,0xc6,0x03,0xcd,0xc7,0x01,0x36,0xd8,0x08,0x5c,0x65,0xb9,0x70,
        0xbb,0x41,0x8f,0x36}, 
        /*TST_SHA1_Expected_output_dataSize*/
        CE2_HASH_SHA1_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),  
        /*TST_MD5_Expected_output_data*/
        {0xba,0x59,0xe1,0xbf,0x85,0x7f,0xb6,0xe1,0xf8,0x8b,0x80,0x55,0xb9,0xad,0x0f,0x68}, 
        /*TST_MD5_Expeced_dataSize*/
        CE2_HASH_MD5_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),  
        /*TST_SHA224_Expected_output_data*/
        {0xc5,0x7f,0x71,0x2b,0x64,0x40,0xd0,0xc8,0xc8,0x46,0xb3,0xfe,0xed,0x96,0x5a,0x60,
        0x20,0x00,0xb7,0x1c,0x4f,0x65,0x8e,0xdb,0x2c,0xc6,0x80,0x9d}, 
        /*TST_SAH224_expected_dataSize*/
        CE2_HASH_SHA224_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_SHA256_Expected_output_data*/
        {0x8b,0x61,0xf7,0xf5,0x5e,0xba,0x18,0xb3,0x26,0x38,0x56,0xc5,0x5f,0x78,0x7a,0xbc,
        0x47,0xd3,0xd2,0x34,0xb0,0x21,0x88,0x06,0xae,0x37,0x45,0xa2,0x3c,0x94,0xdf,0x51}, 
        /*TST_SAH256_expected_dataSize*/
        CE2_HASH_SHA256_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_SHA384_Expected_output_data*/
        {0x1f,0xbe,0x97,0xc6,0xbc,0x19,0x06,0xf8,0xd8,0x1c,0xbe,0xfc,0x84,0x61,0x29,0xba,
        0x9d,0xad,0x4f,0x2a,0x5f,0x1d,0xe8,0x65,0x64,0x6d,0x97,0xcf,0x6f,0x97,0x63,0x8d,
        0x0d,0x8c,0x2f,0xf2,0x66,0xe9,0xbe,0xc6,0xa4,0xc0,0x41,0x08,0xb5,0x33,0x79,0xf0}, 
        /*TST_SAH384_expected_dataSize*/
        CE2_HASH_SHA384_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_SHA512_Expected_output_data*/
        {0x95,0x1c,0x78,0x19,0xb4,0xb4,0xaf,0xb0,0xe1,0x90,0x9b,0xa4,0x9c,0x67,0xb9,0x27,
        0x52,0x94,0xe8,0x48,0xab,0xb5,0x17,0xc3,0x11,0xad,0xf1,0x25,0x88,0x03,0xe2,0xd1,
        0xb6,0x12,0x80,0x19,0x2c,0xc0,0xc3,0xb4,0xce,0x72,0x68,0x29,0x25,0xf0,0x6d,0x50,
        0x84,0x80,0xe4,0xc1,0xa0,0x6c,0xb3,0x10,0x86,0x3d,0x8d,0x95,0xa4,0x48,0x9d,0xd9}, 
        /*TST_SAH512_expected_dataSize*/
        CE2_HASH_SHA512_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
        CE2_HASH_SHA1_mode           
    },      
};

const int TST_NumberOfHMACAcceptanceTests = sizeof(TST_HMAC_Acceptance_TestData)/sizeof(TST_HMAC_Acceptance_TestData[0]);

CE2Error_t TST_TestStatusReturn;

/************************ Private function prototype **********/
/************************ Private Functions *******************/

/* Check returned error code */
CE2Error_t TST_CheckErrorReturn(CE2Error_t  TST_ErrorRet,
                                     char         TST_FuncName[TST_FUNC_STRING_LEN],
                                     char         TST_SubTestName[TST_FUNC_STRING_LEN],
                                     char         TST_MasterTestName[TST_FUNC_STRING_LEN], FILE *out)
{
	if (TST_ErrorRet != CE2_OK)
	{
		fprintf(out, "\nFailed - Master Test Name -%s\n",TST_MasterTestName);
		fprintf(out, "Failed - SubTest Name -%s\n",TST_SubTestName);
		fprintf(out, "Failed - %s failed\n",TST_FuncName);
		fprintf(out, "Failed - CE2_Error returned %lX \n",TST_ErrorRet);

		TST_TestStatusReturn = CE2_TST_FAILED;

		return CE2_TST_FAILED;
	}
	else
	{
		return CE2_TST_VALID;
	}
} /* End of TST_CheckErrorReturn */

/************************ Public Functions ********************/

/***************************************************************
* Function Name: 
*  CE2_TST_HMAC
*
* Inputs:
*  @param out [in] - pointer to file to output debug information;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  This function Is a Acceptance test for HMAC integrated API
*  This function HMAC known vectors using SHA1 and MD5
*  Vector sizes used (in bytes) - 16/32/512/1536
*
* \b
* Algorithm:
*  -# Call the CE2_HMAC function to use the HMAC process;
*  -# Compare the outputted result to the expected one.
***************************************************************/
CE2Error_t CE2_TST_HMAC(FILE * out)
{
  int			useSTDFile = 0;
  int         TST_index;
  CE2Error_t	TST_TestStatus=0;
  CE2Error_t	TST_ATP_Error;
  int 		TST_HMAC_Mode_Index;
  char        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CE2_ATP_TST_HMAC_Acceptance_Integrated";
  int error_code;

	if (out == NULL)
	{
		error_code = fopen_s(&out, TST_HMAC_STD_LOG_FILE_NAME, "w");
		if (error_code != 0)
		{
			printf("Can't create log file '%s'!\n", TST_HMAC_STD_LOG_FILE_NAME);
			return CE2_TST_FAILED;
		}
		useSTDFile = 1;
	}

	PrintTestBeginMsg(out, __FUNCTION__);

    TST_TestStatusReturn = CE2_TST_VALID;

    /*********** Start of test **********************/
    for (TST_HMAC_Mode_Index = 0;   TST_HMAC_Mode_Index <CE2_HASH_NumOfModes ; TST_HMAC_Mode_Index++)
    {
        for (TST_index =0 ; TST_index < TST_NumberOfHMACAcceptanceTests ; TST_index++) /*To run on all test vectors*/
        {
            switch (TST_HMAC_Mode_Index)
            {
            case CE2_HASH_SHA1_mode:
                TST_HMAC_Acceptance_TestData[TST_index].TST_OperationMode = CE2_HASH_SHA1_mode;
                break;
            case CE2_HASH_SHA224_mode:
                TST_HMAC_Acceptance_TestData[TST_index].TST_OperationMode = CE2_HASH_SHA224_mode;
                break;
            case CE2_HASH_SHA256_mode:
                TST_HMAC_Acceptance_TestData[TST_index].TST_OperationMode = CE2_HASH_SHA256_mode;
                break;
            case CE2_HASH_SHA384_mode:
                TST_HMAC_Acceptance_TestData[TST_index].TST_OperationMode = CE2_HASH_SHA384_mode;
                break;
            case CE2_HASH_SHA512_mode:
                TST_HMAC_Acceptance_TestData[TST_index].TST_OperationMode = CE2_HASH_SHA512_mode;
                break;
            case CE2_HASH_MD5_mode:
                TST_HMAC_Acceptance_TestData[TST_index].TST_OperationMode = CE2_HASH_MD5_mode;
                break;
            default:
                break;
            } 

            /* calling the HMAC function */
            TST_ATP_Error = CE2_HMAC( TST_HMAC_Acceptance_TestData[TST_index].TST_OperationMode,
                                      TST_HMAC_Acceptance_TestData[TST_index].TST_key,
                                      TST_HMAC_Acceptance_TestData[TST_index].TST_keySize,                                
                                      TST_HMAC_Acceptance_TestData[TST_index].TST_input_data,
                                      TST_HMAC_Acceptance_TestData[TST_index].TST_input_dataSize,
                                      TST_HMAC_Acceptance_TestData[TST_index].TST_HmacResultBuff);

            TST_TestStatus = TST_CheckErrorReturn(TST_ATP_Error,"CE2_HMAC",TST_HMAC_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName,out);

            /* Compare the result to expected result */
            if (TST_HMAC_Acceptance_TestData[TST_index].TST_OperationMode == CE2_HASH_SHA1_mode)
            {
                TST_ATP_Error = (CE2Error_t)memcmp( TST_HMAC_Acceptance_TestData[TST_index].TST_HmacResultBuff ,
                                                    TST_HMAC_Acceptance_TestData[TST_index].TST_SHA1_Expected_output_data ,
                                                    TST_HMAC_Acceptance_TestData[TST_index].TST_SHA1_Expected_dataSize);            
            }
            else
            {
                TST_ATP_Error = (CE2Error_t)memcmp( TST_HMAC_Acceptance_TestData[TST_index].TST_HmacResultBuff ,
                                                    TST_HMAC_Acceptance_TestData[TST_index].TST_MD5_Expected_output_data ,
                                                    TST_HMAC_Acceptance_TestData[TST_index].TST_MD5_Expected_dataSize);         
            }
                
           /* compare the data then Print the expected data and outputted data*/
            switch (TST_HMAC_Mode_Index)
            {
                case CE2_HASH_SHA1_mode:
                     TST_ATP_Error = (CE2Error_t)memcmp(TST_HMAC_Acceptance_TestData[TST_index].TST_HmacResultBuff ,
                                                                TST_HMAC_Acceptance_TestData[TST_index].TST_SHA1_Expected_output_data ,
                                                                TST_HMAC_Acceptance_TestData[TST_index].TST_SHA1_Expected_dataSize);
                    break;
                case CE2_HASH_SHA224_mode:
                      TST_ATP_Error = (CE2Error_t)memcmp(TST_HMAC_Acceptance_TestData[TST_index].TST_HmacResultBuff ,
                                                                TST_HMAC_Acceptance_TestData[TST_index].TST_SHA224_Expected_output_data ,
                                                                TST_HMAC_Acceptance_TestData[TST_index].TST_SHA224_Expected_dataSize);            
                   break;
                case CE2_HASH_SHA256_mode:
                      TST_ATP_Error = (CE2Error_t)memcmp(TST_HMAC_Acceptance_TestData[TST_index].TST_HmacResultBuff ,
                                                                TST_HMAC_Acceptance_TestData[TST_index].TST_SHA256_Expected_output_data ,
                                                                TST_HMAC_Acceptance_TestData[TST_index].TST_SHA256_Expected_dataSize);            
                   break;
                case CE2_HASH_SHA384_mode:
                      TST_ATP_Error = (CE2Error_t)memcmp(TST_HMAC_Acceptance_TestData[TST_index].TST_HmacResultBuff ,
                                                                TST_HMAC_Acceptance_TestData[TST_index].TST_SHA384_Expected_output_data ,
                                                                TST_HMAC_Acceptance_TestData[TST_index].TST_SHA384_Expected_dataSize);            
                   break;
                case CE2_HASH_SHA512_mode:
                      TST_ATP_Error = (CE2Error_t)memcmp(TST_HMAC_Acceptance_TestData[TST_index].TST_HmacResultBuff ,
                                                                TST_HMAC_Acceptance_TestData[TST_index].TST_SHA512_Expected_output_data ,
                                                                TST_HMAC_Acceptance_TestData[TST_index].TST_SHA512_Expected_dataSize);            
                    break;
                case CE2_HASH_MD5_mode:
                      TST_ATP_Error = (CE2Error_t)memcmp(TST_HMAC_Acceptance_TestData[TST_index].TST_HmacResultBuff ,
                                                                TST_HMAC_Acceptance_TestData[TST_index].TST_MD5_Expected_output_data ,
                                                                TST_HMAC_Acceptance_TestData[TST_index].TST_MD5_Expected_dataSize);            
                    break;
                default:
                    break;
            }
            TST_TestStatus = TST_CheckErrorReturn(TST_ATP_Error,"memcmp",TST_HMAC_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName,out);
        }/*End of TST_index//TST_NumberOfAcceptanceTests*/      
    } /* End of TST_HMAC_Mode_Index loop*/

	PrintTestEndMsg(out, __FUNCTION__, TST_TestStatusReturn);

	if (useSTDFile) fclose(out);

	return TST_TestStatusReturn;
} /* End of CE2_TST_HMAC */
